# 格式化上传文件名

## 支持版本 ##
支持 UEditor 1.4.2+ 的版本

## 功能说明 ##
上传文件名容易冲突，编辑器提供了前端配置上传文件名格式，可以在config文件配置fileNameFormat项，后台上传文件会按照配置的格式命名。

## 格式化字符串的参数 ##
```
{filename}  //会替换成文件名 [要注意中文文件乱码问题]
{rand:6}    //会替换成随机数,后面的数字是随机数的位数
{time}      //会替换成时间戳
{yyyy}      //会替换成四位年份
{yy}        //会替换成两位年份
{mm}        //会替换成两位月份
{dd}        //会替换成两位日期
{hh}        //会替换成两位小时
{ii}        //会替换成两位分钟
{ss}        //会替换成两位秒
```

## 例子 ##

### 例子一
配置项为：
``` imagePathFormat = "/ueditor/php/upload/image/{yyyy}-{mm}-{dd}_{rand:4}_{filename}" ```
上传的文件名可能是这样：
``` "2013-12-16_7126_照片.jpg" ```
存放的路径是www目录下的文件夹：
``` ueditor/php/upload/image```

### 例子二
配置项为：
``` filePathFormat = "/upload/file/{time}_{rand:5}" ```
上传的文件名可能是这样：
``` "1387191121817_29461.jpg" ```
存放的路径是www目录下的文件夹：
``` upload/file```

## 文件名冲突 ##
当按照模板命名文件，依旧出现冲突,后台自动在文件名最后添加上_1或_2等。

## 非法字符 ##
后台会过滤模板上的非法字符，非法字符列表如下，会替换成空：
``` \ : * ? " < > |```
